/* Copyright 2023 - Herber eDevelopment - Jaroslav Herber */

// For old devices!
if( typeof(NodeList.prototype.forEach) === 'undefined' ) {
	NodeList.prototype.forEach = Array.prototype.forEach;
}

var i18n = {
'en': {
	'yes': 'да', 'no': 'нет',

	'm3uSource': 'URL-АДРЕС ПЛЕЙЛИСТА',
	'chooseLang': 'ЯЗЫК',
	'usbLoadLabel': 'ЗАГРУЗИТЬ ПЛЕЙЛИСТ С USB',
	'openUsbButton': 'ПОСМОТРЕТЬ USB',
	'localLoadLabel': 'ЛОКАЛЬНЫЙ ПЛЕЙЛИСТ',
	'openExplorerButton': 'ЗАГРУЗИТЬ ФАЙЛ',
	'openHistoryButton': 'ПЛЕЙЛИСТЫ',
	'downloadButton': 'ДОБАВИТЬ ПЛЕЙЛИСТ',
	'saveButton': 'СМОТРЕТЬ ТВ',
	'deleteButton': 'УДАЛИТЬ',
	'generalSettingsButton': 'ОБЩИЕ НАСТРОЙКИ',
	'advancedSettingsButton': 'ДОПОЛНИТЕЛЬНЫЕ НАСТРОЙКИ',

	'closeAppHint': 'Вы хотите закрыть это приложение?',
	'hideModalHint': 'Нажмите любую клавишу, чтобы закрыть это уведомление.',
	'playlistDownloaded': 'Плейлист успешно загружен.<br>Загружено %i каналов.',
	'channelsLoaded': 'каналов',
	'filterNoResults': 'Нет каналов, соответствующих указанному фильтру.',

	'redButtonHint': '<span class="red-button">A</span> Поиск',
	'helpHint': 'Нажмите кнопку <span class="red-button">A</span>, чтобы вставить список демонстрационных каналов.<br><br>Нажмите INFO на пульте дистанционного управления в любой момент, чтобы открыть руководство пользователя.',

	'supportContact': '<font size="6"><br><br>🔸Для просмотра телевидения нажать🔸Добавить плейлист🔸далее в🔹Дополнительных настройках🔹включить ▫️EPG ▫️и нажать▫️скачать EPG сейчас▫️вернуться в🔹Общие настройки🔹нажать🔸Смотреть ТВ🔸</font>',
	'donate': 'Если вам нравится это приложение, подпишитесь на Telegram<br>🄸🄿🅃🅅 🅂🄷🄰🅁🄴🄳<br>▫️▫️▫️▫️▫️▫️▫️▫️▫️▫️<br><b class="NOBR">https://t.me/iptv_shared</b>',
	'donatePP': 'Сбербанк', 'donateKK': 'Telegram',
	'downloadM3uStatus': 'Плейлист загружается. Пожалуйста, подождите несколько секунд.',
	'usbMountedStatus': 'USB mounted',

	'connectionLost': 'Потеряно сетевое соединение. Пожалуйста, проверьте свою сеть.',
	'checkM3uError': 'Не удалось загрузить плейлист. Код состояния HTTP: ',
	'checkM3uFileError': 'Неверный m3u(8)-плейлист. Пожалуйста, проверьте файл.',
	'checkM3uDownloadError': 'Не удалось загрузить плейлист. Пожалуйста, проверьте URL-адрес',
	'checkM3uDownloadSizeError': 'В плейлисте слишком много каналов. Пожалуйста, уменьшите их до 20.000 каналов.',
	'checkM3uTimeoutError': 'Время загрузки плейлиста истекло. Пожалуйста, попробуйте еще раз.',
	'errorNoUsbMounted': 'USB-накопитель не распознается. Сначала подключите USB-накопитель.',
	'errorNoM3uUrl': 'Пожалуйста, введите URL вашего плейлиста m3u(8).',
	'channelLoadError': 'Этот канал сейчас недоступен. Пожалуйста, попробуйте позже.',
	'channelLoadConnectionFailed': '(Не удалось подключиться к потоку.)',
	'channelNotSupportedFile': 'Этот канал не может быть загружен из-за несовместимого формата.',
	'errorNoFavouritesYet': 'У вас пока нет избранных каналов. Нажмите ЖЕЛТУЮ кнопку, чтобы добавить канал в избранное.',
	'errorNoPlaylistHistory': 'Плейлиста в истории пока нет. Пожалуйста, вставьте URL в поле ниже.',

	// Menu
	'searchPlaceholder': 'Поиск',
	'allChannels': 'Все каналы',
	'favourites': '⭐ Избранное',
	'groups': 'группы',
	'channels': 'каналы',
	'settings_menu': 'Настройки',
	'epg_menu': 'Телегид',
	'guide_menu': 'Инструкция',

	'guideControlsHeadline': 'Инструкция',

	// Advanced Settings
	'tabGeneralSettings': 'Общие настройки',
	'tabAdvancedSettings': 'Дополнительные настройки',
	'chooseMousewheel': 'Колесо мыши',
	'volumeSetting': 'Увеличение/уменьшение громкости',
	'channelSetting': 'Канал вверх/вниз',
	'reloadPlaylistOnStart': 'АВТООБНОВЛЕНИЕ ПЛЕЙЛИСТА',
	'bufferSetting': 'БУФЕР',

	// Channel Settings
	'loading': 'загрузка...',
	'audioTrack': 'Аудиодорожка',
	'subtitleTrack': 'Дорожка субтитров',
	'channelSettings': 'Настройки канала',
	'channelSettingSubtitle': 'субтитры / аудио',
	'channelSettingFavs': 'поместить канал в избранное',
	'channelSettingPlayback': 'показать управление воспроизведением',
	'channelSettingAudioDefault': 'дорожка по умолчанию',
	'channelSettingSubNoTrack': 'недоступно',
	'channelSettingSubOff': 'отключить',
	'channelSettingResolution': 'разрешение',

	// EPG
	'epgSource': 'ИСТОЧНИК EPG',
	'usePlaylistEpgUrl': 'Вместо этого использовать источник EPG из вашего плейлиста?',
	'epgTimeShift': 'EPG ТАЙМШИФТ',
	'epgGrabInterval': 'ИНТЕРВАЛ ЗАХВАТА EPG',
	'downloadEpgButton': 'СКАЧАТЬ EPG СЕЙЧАС',
	'noEpgForChannel': 'Нет программы передач',
	'noEpgUrlGiven': 'Не задан URL-адрес EPG',
	'epgQuotaExceededError': 'Недостаточно свободного места для сохранения данных EPG. Пожалуйста, освободите место. Например, удалив неиспользуемые приложения.',
	'epgNotCompatibleWithPlaylist': 'Ваш плейлист несовместим с этим EPG-URL.',
	'epgIsDownloading': 'Загрузка EPG...',
	'epgChannelsProcessed': 'каналы: ',
	'epgProgramsProcessed': 'программы: ',
	'epgNow': 'Сейчас',
	'epgAfter': 'После этого',

},
'ru': {
	'yes': 'да', 'no': 'нет',

	'm3uSource': 'URL-АДРЕС ПЛЕЙЛИСТА',
	'chooseLang': 'ЯЗЫК',
	'usbLoadLabel': 'ЗАГРУЗИТЬ ПЛЕЙЛИСТ С USB',
	'openUsbButton': 'ПОСМОТРЕТЬ USB',
	'localLoadLabel': 'ЛОКАЛЬНЫЙ ПЛЕЙЛИСТ',
	'openExplorerButton': 'ЗАГРУЗИТЬ ФАЙЛ',
	'openHistoryButton': 'ПЛЕЙЛИСТЫ',
	'downloadButton': 'ДОБАВИТЬ ПЛЕЙЛИСТ',
	'saveButton': 'СМОТРЕТЬ ТВ',
	'deleteButton': 'УДАЛИТЬ',
	'generalSettingsButton': 'ОБЩИЕ НАСТРОЙКИ',
	'advancedSettingsButton': 'ДОПОЛНИТЕЛЬНЫЕ НАСТРОЙКИ',

	'closeAppHint': 'Вы хотите закрыть это приложение?',
	'hideModalHint': 'Нажмите любую клавишу, чтобы закрыть это уведомление.',
	'playlistDownloaded': 'Плейлист успешно загружен.<br>Загружено %i каналов.',
	'channelsLoaded': 'каналов',
	'filterNoResults': 'Нет каналов, соответствующих указанному фильтру.',

	'redButtonHint': '<span class="red-button">A</span> Поиск',
	'helpHint': 'Нажмите кнопку <span class="red-button">A</span>, чтобы вставить список демонстрационных каналов.<br><br>Нажмите INFO на пульте дистанционного управления в любой момент, чтобы открыть руководство пользователя.',

	'supportContact': '<font size="6"><br><br>🔸Для просмотра телевидения нажать🔸Добавить плейлист🔸далее в🔹Дополнительных настройках🔹включить ▫️EPG ▫️и нажать▫️скачать EPG сейчас▫️вернуться в🔹Общие настройки🔹нажать🔸Смотреть ТВ🔸</font>',
	'donate': 'Если вам нравится это приложение, подпишитесь на Telegram<br>🄸🄿🅃🅅 🅂🄷🄰🅁🄴🄳<br>▫️▫️▫️▫️▫️▫️▫️▫️▫️▫️<br><b class="NOBR">https://t.me/iptv_shared</b>',
	'donatePP': 'Сбербанк', 'donateKK': 'Telegram',
	'downloadM3uStatus': 'Плейлист загружается. Пожалуйста, подождите несколько секунд.',
	'usbMountedStatus': 'USB mounted',

	'connectionLost': 'Потеряно сетевое соединение. Пожалуйста, проверьте свою сеть.',
	'checkM3uError': 'Не удалось загрузить плейлист. Код состояния HTTP: ',
	'checkM3uFileError': 'Неверный m3u(8)-плейлист. Пожалуйста, проверьте файл.',
	'checkM3uDownloadError': 'Не удалось загрузить плейлист. Пожалуйста, проверьте URL-адрес',
	'checkM3uDownloadSizeError': 'В плейлисте слишком много каналов. Пожалуйста, уменьшите их до 20.000 каналов.',
	'checkM3uTimeoutError': 'Время загрузки плейлиста истекло. Пожалуйста, попробуйте еще раз.',
	'errorNoUsbMounted': 'USB-накопитель не распознается. Сначала подключите USB-накопитель.',
	'errorNoM3uUrl': 'Пожалуйста, введите URL вашего плейлиста m3u(8).',
	'channelLoadError': 'Этот канал сейчас недоступен. Пожалуйста, попробуйте позже.',
	'channelLoadConnectionFailed': '(Не удалось подключиться к потоку.)',
	'channelNotSupportedFile': 'Этот канал не может быть загружен из-за несовместимого формата.',
	'errorNoFavouritesYet': 'У вас пока нет избранных каналов. Нажмите ЖЕЛТУЮ кнопку, чтобы добавить канал в избранное.',
	'errorNoPlaylistHistory': 'Плейлиста в истории пока нет. Пожалуйста, вставьте URL в поле ниже.',

	// Menu
	'searchPlaceholder': 'Поиск',
	'allChannels': 'Все каналы',
	'favourites': '⭐ Избранное',
	'groups': 'группы',
	'channels': 'каналы',
	'settings_menu': 'Настройки',
	'epg_menu': 'Телегид',
	'guide_menu': 'Инструкция',

	'guideControlsHeadline': 'Инструкция',

	// Advanced Settings
	'tabGeneralSettings': 'Общие настройки',
	'tabAdvancedSettings': 'Дополнительные настройки',
	'chooseMousewheel': 'Колесо мыши',
	'volumeSetting': 'Увеличение/уменьшение громкости',
	'channelSetting': 'Канал вверх/вниз',
	'reloadPlaylistOnStart': 'АВТООБНОВЛЕНИЕ ПЛЕЙЛИСТА',
	'bufferSetting': 'БУФЕР',

	// Channel Settings
	'loading': 'загрузка...',
	'audioTrack': 'Аудиодорожка',
	'subtitleTrack': 'Дорожка субтитров',
	'channelSettings': 'Настройки канала',
	'channelSettingSubtitle': 'субтитры / аудио',
	'channelSettingFavs': 'поместить канал в избранное',
	'channelSettingPlayback': 'показать управление воспроизведением',
	'channelSettingAudioDefault': 'дорожка по умолчанию',
	'channelSettingSubNoTrack': 'недоступно',
	'channelSettingSubOff': 'отключить',
	'channelSettingResolution': 'разрешение',

	// EPG
	'epgSource': 'ИСТОЧНИК EPG',
	'usePlaylistEpgUrl': 'Вместо этого использовать источник EPG из вашего плейлиста?',
	'epgTimeShift': 'EPG ТАЙМШИФТ',
	'epgGrabInterval': 'ИНТЕРВАЛ ЗАХВАТА EPG',
	'downloadEpgButton': 'СКАЧАТЬ EPG СЕЙЧАС',
	'noEpgForChannel': 'Нет программы передач',
	'noEpgUrlGiven': 'Не задан URL-адрес EPG',
	'epgQuotaExceededError': 'Недостаточно свободного места для сохранения данных EPG. Пожалуйста, освободите место. Например, удалив неиспользуемые приложения.',
	'epgNotCompatibleWithPlaylist': 'Ваш плейлист несовместим с этим EPG-URL.',
	'epgIsDownloading': 'Загрузка EPG...',
	'epgChannelsProcessed': 'каналы: ',
	'epgProgramsProcessed': 'программы: ',
	'epgNow': 'Сейчас',
	'epgAfter': 'После этого',

},

};


function isLangAllowed( sLangId ) {

	switch( sLangId ) {
		case 'en':
		case 'ru':
			return true;
	}

	return false;

}

function setLangId( sLangId ) {
	if( sLangId && isLangAllowed(sLangId) ) {
		localStorage.setItem('sLangId', sLangId);
		applyLang();
	} else {
		console.log('Unknown language: ' + sLangId);
	}
}

function getLangId() {
	var sStoredLang = localStorage.getItem('sLangId');

	if( !sStoredLang ) {
		sStoredLang = getDeviceLang();
		setLangId(sStoredLang);
	}

	if( !isLangAllowed(sStoredLang) ) {
		sStoredLang = 'en';
	}
	return sStoredLang;
}


function getLang( sKey, sForceLangId ) {

	sForceLangId = sForceLangId || false;

	if( sForceLangId ) {
		var sLangId = sForceLangId;
	} else {
		var sLangId = getLangId();
	}

	if( !isLangAllowed(sLangId) ) {
		sLangId = 'en'; // default lang
	}

	var aLang = i18n[sLangId];
	if( aLang ) {
		if( aLang[sKey] ) {
			return aLang[sKey];
		} else if( sLangId !== 'en' ) {
			console.log('Lang fallback: ' + sLangId + ' --- ' + sKey);
			return getLang(sKey, 'en');
		}
	}

	return '';

}

function applyLang() {

	var sLangId = getLangId();
	document.getElementById('sLangId').value = sLangId;

	var aElements = document.querySelectorAll('.i18nInput');
	aElements.forEach(function(oEl) {
		var sLangKey = oEl.dataset.langid;
		if( sLangKey ) {
			var sLangValue = getLang(sLangKey);
			if( sLangValue ) {
				oEl.value = sLangValue;
			}
		}
	});

	aElements = document.querySelectorAll('.i18nPlaceholder');
	aElements.forEach(function(oEl) {
		var sLangKey = oEl.dataset.langid;
		if( sLangKey ) {
			var sLangValue = getLang(sLangKey);
			if( sLangValue ) {
				oEl.placeholder = sLangValue;
			}
		}
	});

	if( sLangId === 'ar' ) {
		document.body.classList.add('rtl');
	} else {
		document.body.classList.remove('rtl');
	}

	aElements = document.querySelectorAll('.i18n');
	aElements.forEach(function(oEl) {
		var sLangKey = oEl.dataset.langid;
		if( sLangKey ) {
			var sLangValue = getLang(sLangKey);
			if( sLangValue ) {
				oEl.innerHTML = sLangValue;
			}
		}
	});

}


function getDeviceLang() {

	try {
		if( sDeviceFamily === 'LG' && window.PalmSystem && window.PalmSystem.country ) {
			var aDeviceCountry = JSON.parse(window.PalmSystem.country);
			if( aDeviceCountry && aDeviceCountry['country'] ) {
				switch( aDeviceCountry['country'] ) {
					case 'RUS':
						return 'ru';
					default:
						return 'en';
				}
			}
		} else if( window.navigator.language ) {
			var sDeviceLang = window.navigator.language;
			if( sDeviceLang.length == 5 ) {
				sDeviceLang = sDeviceLang.substr(0, 2);
			}

			if( sDeviceLang && isLangAllowed(sDeviceLang) ) {
				return sDeviceLang;
			}
		}
	} catch( e ) { console.log(e.message) }

	return 'en';

}
